﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>
<%@ Import Namespace="Soneta.Types" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Ewidencja środków trwałych</title>

	<script runat="server">
  
		private WartosciSrodkaWorker worker = new WartosciSrodkaWorker();
		private SrodkiTrwale.Params parameters;

		protected void dc_ContextLoad(object sender, EventArgs e)
		{
			parameters = (SrodkiTrwale.Params)dc.Context[typeof(SrodkiTrwale.Params)];

		}

		void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			SrodekTrwalyBaseHistoria sHistoria = (SrodekTrwalyBaseHistoria)args.Row;

			if (sHistoria.Srodek.Stan == StanSrodkaTrwalego.Wpisany)
			{
				args.VisibleRow = false;
				return;
			}

			if (sHistoria.Srodek.DataRejestracji > parameters.Aktualnosc)
			{
				args.VisibleRow = false;
				return;
			}

			if (!sHistoria.Srodek.DataLikwidacji.IsNull && sHistoria.Srodek.DataLikwidacji <= parameters.Aktualnosc)
			{
				DataLikwidacji.EditValue = sHistoria.Srodek.DataLikwidacji;

				if (!sHistoria.Srodek.ZbycieData.IsNull && sHistoria.Srodek.ZbycieData <= parameters.Aktualnosc)
					PrzyczynaZbycia.EditValue = sHistoria.Srodek.ZbycieData + (sHistoria.Srodek.LT != null ? " / " + sHistoria.Srodek.LT.Tytul.Tytul : String.Empty);
			}
			else
			{
				DataLikwidacji.EditValue = String.Empty;
				PrzyczynaZbycia.EditValue = String.Empty;
			}

			worker.SrodekHistoria = sHistoria;
			worker.Data = parameters.Aktualnosc;

			ZmianaWartosciB.EditValue = worker.WartoscBilansowa - worker.WartoscPoczatkowaBilansowa;
			ZmianaWartosciP.EditValue = worker.WartoscPodatkowa - worker.WartoscPoczatkowaPodatkowa;

			//
			// amortyzacja na rok
			//

			FromTo okresObrachunkowy;
			if (sHistoria.Module.Config.Ogólne.UwzględniajKontekstOkresuObrach)
			{
				OkresObrachunkowy okres = KsiegaModule.GetInstance(sHistoria).OkresyObrach[parameters.Aktualnosc];
				if (okres == null)
					throw new ApplicationException(String.Format("Brak okresu obrachunkowego dla daty aktualności {0}." , parameters.Aktualnosc));
				okresObrachunkowy = okres.Okres;
			}
			else
				okresObrachunkowy = FromTo.Year(parameters.Aktualnosc);

			Currency wartoscBilansowa = Currency.Zero;
			Currency wartoscPodatkowa = Currency.Zero;

			Plan plan = new Plan(sHistoria.Srodek, parameters.Aktualnosc);
			
			foreach (Plan.PlanItem item in plan.Items)
				if (okresObrachunkowy.Contains(item.Okres))
				{
					wartoscBilansowa += item.WartoscBilansowa;
					wartoscPodatkowa += item.WartoscPodatkowa;
				}

			PlanB.EditValue = wartoscBilansowa;
			PlanP.EditValue = wartoscPodatkowa;
		}

	</script>

</head>
<body>
	<form method="post" runat="server">
		<ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad" Landscape="true" BottomMargin="10" LeftMargin="10" RightMargin="10" 
        TopMargin="10" />
		<eb:ReportHeader ID="ReportHeader" runat="server" Title="Ewidencja środków trwałych|</STRONG>Aktualność:<STRONG> {4}|</STRONG>Typ:<STRONG> {0}|</STRONG>Stan:<STRONG> {1}|</STRONG>Amortyzacja:<STRONG> {2}|</STRONG>Wartości:<STRONG> {3}"
			DataMember0="SrodkiTrwale+Params.Typ" DataMember1="SrodkiTrwale+Params.Stan" DataMember2="SrodkiTrwale+Params.Amortyzacja" DataMember3="SrodkiTrwale+Params.Wartosci" DataMember4="SrodkiTrwale+Params.Aktualnosc" />

		<ea:Grid ID="Grid" runat="server" RowsInRow="2" OnBeforeRow="Grid1_BeforeRow" LinkedRows="History" RowTypeName="Soneta.SrodkiTrwale.SrodekTrwalyBaseHistoria,Soneta.Ksiega"
			Sort="KRST.Grupa,NumerInwentarzowy" GroupLine="Grupa: {0}" GroupData0="KRST.Grupa.Symbol" ShowGroupSum="true" GroupSumText="Suma grupy" >
			<Columns>
				<ea:GridColumn ID="GridColumn1" runat="server" Align="Center" Width="5" Caption="LP." DataMember="#" />
				<ea:GridColumn ID="GridColumn2" runat="server" Align="Center" Width="5" Caption="KŚT" DataMember="KRST.Symbol" EncodeHtml="true" />
				<ea:GridColumn ID="GridColumn5" runat="server" Align="Center" Caption="Nr inwentarzowy" DataMember="Srodek.NumerInwentarzowy" EncodeHtml="true" />
				<ea:GridColumn ID="GridColumn3" runat="server" Align="Center" Caption="Nazwa" DataMember="Srodek.Nazwa" EncodeHtml="true" ColSpan="2" />
				<ea:GridColumn ID="GridColumn4" runat="server" Align="Center" Caption="Nr dok. pozyskania" DataMember="Srodek.PozyskanieNrDokumentu" EncodeHtml="true" />
				<ea:GridColumn ID="GridColumn6" runat="server" Align="Center" Width="12" Caption="Data nabycia" DataMember="Srodek.PozyskanieData" />
				<ea:GridColumn ID="GridColumn7" runat="server" Align="Center" Width="12" Caption="Data rozpocz. użytkowania" DataMember="Srodek.DataRozpoczeciaUzytkowania" />
				<ea:GridColumn ID="GridColumn8" runat="server" Align="Center" Width="22" Caption="Amortyzacja (B)" DataMember="Bilansowa" Total="Info" />
				<ea:GridColumn ID="GridColumn9" runat="server" Align="Center" Width="22" Caption="Amortyzacja (P)" DataMember="Podatkowa" />
				<ea:GridColumn ID="GridColumn10" runat="server" Format="{0:n}" Align="Right" Caption="Wartość początkowa (B)" DataMember="Workers.WartosciSrodka.WartoscPoczatkowaBilansowa" Total="Sum" />
				<ea:GridColumn ID="GridColumn11" runat="server" Format="{0:n}" Align="Right" Caption="Wartość początkowa (P)" DataMember="Workers.WartosciSrodka.WartoscPoczatkowaPodatkowa" Total="Sum" />
				<ea:GridColumn ID="ZmianaWartosciB" runat="server" Format="{0:n}" Align="Right" Caption="Zmiana wartości (B)" Total="Sum" />
				<ea:GridColumn ID="ZmianaWartosciP" runat="server" Format="{0:n}" Align="Right" Caption="Zmiana wartości (P)" Total="Sum" />
				<ea:GridColumn ID="GridColumn14" runat="server" Format="{0:n}" Align="Right" Caption="Wartość bieżąca (B)" DataMember="Workers.WartosciSrodka.WartoscBilansowa" Total="Sum" />
				<ea:GridColumn ID="GridColumn15" runat="server" Format="{0:n}" Align="Right" Caption="Wartość bieżąca (P)" DataMember="Workers.WartosciSrodka.WartoscPodatkowa" Total="Sum" />
				<ea:GridColumn ID="PlanB" runat="server" Format="{0:n}" Align="Right" Caption="Planowane odpisy bieżące (B)" Total="Sum" />
				<ea:GridColumn ID="PlanP" runat="server" Format="{0:n}" Align="Right" Caption="Planowane odpisy bieżące (P)" Total="Sum" />
				<ea:GridColumn ID="GridColumn16" runat="server" Format="{0:n}" Align="Right" Caption="Odpisy bieżące (B)" DataMember="Workers.WartosciSrodka.OdpisyBilansoweRokBiezacy" Total="Sum" />
				<ea:GridColumn ID="GridColumn17" runat="server" Format="{0:n}" Align="Right" Caption="Odpisy bieżące (P)" DataMember="Workers.WartosciSrodka.OdpisyPodatkoweZUlgamiRokBiezacy" Total="Sum" />
				<ea:GridColumn ID="GridColumn18" runat="server" Format="{0:n}" Align="Right" Caption="Odpisy narastająco (B)" DataMember="Workers.WartosciSrodka.OdpisyBilansowe" Total="Sum" />
				<ea:GridColumn ID="GridColumn19" runat="server" Format="{0:n}" Align="Right" Caption="Odpisy narastająco (P)" DataMember="Workers.WartosciSrodka.OdpisyPodatkowe" Total="Sum" />
				<ea:GridColumn ID="DataLikwidacji" runat="server" Align="Center" Caption="Data likwidacji" />
				<ea:GridColumn ID="PrzyczynaZbycia" runat="server" Align="Center" Caption="Data zbycia / przyczyna zbycia" />
			</Columns>
		</ea:Grid>
		<eb:ReportFooter ID="ReportFooter" runat="server"></eb:ReportFooter>
	</form>
</body>
</html>

